/*********************************************************************/
/* Project Name: KBI.mcp                                             */
/* Source fle name: KBI.c                                            */
/*********************************************************************/
/* Copyright (C) 2007 Freescale Semiconductor, Inc.                  */
/* All Rights Reserved                                               */
/*********************************************************************/
/*********************************************************************/
/* Hands on training for QE128 MCU's                                 */
/* Module: KBI                                                       */
/* The firmware was developed and tested on CodeWarrior 6.0 version  */
/*                                                                   */
/* Description: The KBI module is configured to detect falling edge  */
/* when a push button is pressed (PTA2 or PTA3) PTC0 toggles         */                                                           
/*********************************************************************/
/*                                                                   */
/* Date: 12/03/2007                                                  */
/* Ulises Corrales Salgado                                           */
/* Application Engineer                                              */
/* RTAC Americas                                                     */
/*********************************************************************/                                                                      


#include <hidef.h> /* for EnableInterrupts macro */
#include "derivative.h" /* include peripheral declarations */


/*********************************************************************/
/*  Function declarations                                            */
/*********************************************************************/

void MCU_Init(void) {
  
 SOPT1 = 0x23;          /* Watchdog disable. Stop Mode Enable. Background Pin enable. RESET pin enable */  
 SCGC1 = 0x00;          /* Disable Bus clock to unused peripherals */
 SCGC2 = 0x10;          /* Bus Clock to the KBI module is enabled */
}

void GPIO_Init(void) { 
  
 PTAPE = 0x0C;          /* Enable PTA2 and PTA3 pins Internal Pullups */
 PTCDD = 0x01;          /* Configure PTC0 pin as output */
 PTCD = 0x01;           /* Put 1 in PTC0 pin to turn the LED off */
}

void KBI_configuration(void) {
 
 KBI1SC = 0x06;         /* KBI interrupt request enabled. Detects edges only */
 KBI1PE = 0x0C;         /* PTA2 and PTA3 enabled as Keyboard interrupts */
 KBI1ES = 0x00;         /* Pins detects falling edge */
}


/*********************************************************************/
/*  Main Function                                                    */
/*********************************************************************/

void main(void) {

  MCU_Init();       /* Function that initializes the MCU */
  GPIO_Init();      /* Function that initializes the Ports of the MCU */
  KBI_configuration();       /* Function that initializes the KBI module */

  EnableInterrupts; /* enable interrupts */
  
   
  for(;;) {

  } /* loop forever */
  /* please make sure that you never leave this function */
}

void interrupt VectorNumber_Vkeyboard KBI_ISR(void) {

KBI1SC_KBACK = 1;   /* Clear the KBI interrupt flag */

PTCD_PTCD0 ^= 1;    /* Toggles PTE0 */
}